'''
Created on 24.10.2017

@author: PRORJM
'''

class EnergySupply(object):
    '''
    classdocs
    '''

    def __init__(self, id_number, tech, resource, ee, he, cap, inv, om, lt):
        self.node_id = id_number
        self.name = tech+' '+str(id_number)
        self.tech = tech
        self.resource = resource
        self.elec_eff = ee
        self.heat_eff = he
        
        # capacity in kW or in the case of solar collectors/pvs; area in m2
        self.capacity = cap
        
        # specific investment
        self.spec_inv = inv
        
        # operation and maintenance costs
        self.om = om
        
        # life time
        self.lifetime = lt
        
        # optimisation results:
        
        # production and consumption (fuel)
        self.elec_production = []
        self.heat_production = []
        self.consumption = []
        
        # utilisation rate, elec + heat (if applicable)
        self.utilisation = 0
        
    
    def calculateInvestment(self):
        return self.capacity*self.spec_inv